/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#include "rotaryswitch.h"
#include <QDebug>
#include <QThread>

RotarySwitch::RotarySwitch(QStringList pins)
{
	qDebug() << "RotarySwitch pins:" << pins;
	GPIO_Preparation(pins);

	QThread::msleep(1000);

	for (int i = 0; i < list_RotaryPosition.count(); i++)
	{
		list_RotaryPosition.at(i)->setDirection("in");
	}

	poll_timer = new QTimer();
	connect(poll_timer, &QTimer::timeout, this, &RotarySwitch::poll_position);
//	poll_timer->start(200);
}

RotarySwitch::~RotarySwitch()
{
	for (int i = 0; i < list_RotaryPosition.count(); i++)
	{
		delete list_RotaryPosition.at(i);
	}
	poll_timer->stop();
}

void RotarySwitch::GPIO_Preparation(QStringList pins)
{
	for (int i = 0; i < pins.count(); i++)
	{
		GPIO_RotaryPosition = new GPIOClass(pins.at(i));
		list_RotaryPosition.append(GPIO_RotaryPosition);
	}
}

bool RotarySwitch::GPIO_Read()
{
	int validity_check_count = 0;

	for (int i = 0; i < list_RotaryPosition.count(); i++)
	{
		switch_position.append(list_RotaryPosition.at(i)->readValue());
		if (switch_position.at(i) > 1)
		{
			validity_check_count++;
		}
	}

	if (validity_check_count > 1)
	{
		return false;
	}

	return true;
}

int RotarySwitch::get_Position()
{
	if (GPIO_Read() == true)
	{
		for (int i = 0; i < list_RotaryPosition.count(); i++)
		{
			if (switch_position.at(i) > 0)
			{
				return i;
			}
		}
//		qDebug() << "All positions read 0";
	}
	else
	{
		qDebug() << "GPIO_Read() returned false";
	}

	return -1;
}

void RotarySwitch::poll_position()
{
	int pos = get_Position();
	qDebug() << pos;
}
